
########################################################################
# floppyPopUpDisable -	Disable the given floppy in the pop-up menu.
#                       This is used when a floppy isn't loaded.
########################################################################
proc floppyPopUpDisable {num} {
    global Fpu

    set m $Fpu($num)

    $m entryconfigure "Load Disk*" -state normal
    $m entryconfigure "Eject Disk*" -state disabled
    $m entryconfigure "Enabled*" -state disabled
    $m entryconfigure "Write*" -state disabled
    $m entryconfigure "Enabled*" -state disabled
    $m entryconfigure "Upload*" -state normal
    $m entryconfigure "Save*" -state disabled

    for { set i 0 } { $i < 3 } { incr i } {
	if { $i != $num } {
	    $m entryconfigure "Swap*$i*" -state disabled
	}
    }
}

########################################################################
# floppyPopUpEnable() -	Enable the given floppy in the pop-up menu.
#                       Used when a floppy is loaded.
########################################################################
proc floppyPopUpEnable {num} {
    global Fpu

    set m $Fpu($num)

    $m entryconfigure "Load Disk*" -state normal
    $m entryconfigure "Eject Disk*" -state normal
    $m entryconfigure "Enabled*" -state normal
    $m entryconfigure "Write*" -state normal
    $m entryconfigure "Enabled*" -state normal
    $m entryconfigure "Upload*" -state normal
    $m entryconfigure "Save*" -state normal

    for { set i 0 } { $i < 3 } { incr i } {
	if { $i != $num } {
	    $m entryconfigure "Swap*$i*" -state normal
	}
    }
}

########################################################################
# floppyPopUpMenus() -	Set up the floppy pop-up menus for a right click.
########################################################################
proc floppyPopUpMenusCreate {} {
    global Fpu

    # popup menus

    for { set i 0 } { $i < 3 } { incr i } {
	set Fpu($i) .fpu$i
	menu $Fpu($i)
	$Fpu($i) configure -title "Disk $i Operations"
	$Fpu($i) add command -label "Load Disk $i" -state normal \
		-command [list floppyLoad $i ]
	$Fpu($i) add command -label "Eject Disk $i" -state disabled \
		-command [list floppyEject $i ]
	$Fpu($i) add separator
	$Fpu($i) add checkbutton -label "Enabled" -state disabled \
		-variable floppyEnabled($i) \
		-command [list menuFloppyEnableToggle $i]
	$Fpu($i) add checkbutton -label "Write Protect" -state disabled \
		-variable floppyProtected($i)
	$Fpu($i) add separator
	for { set j 0 } { $j < 3 } { incr j } {
	    if { $i != $j } {
		$Fpu($i) add command -label "Swap with Disk $j" -state disabled \
			-command [list floppySwap $i $j]
	    }
	}
	$Fpu($i) add separator
	$Fpu($i) add command -label "Upload Disk $i..." -state normal \
		-command [list floppyUpload $i]
	$Fpu($i) add command -label "Save Disk $i..." -state disabled \
		-command [list floppySave $i]
    }
}

proc floppyPopUpMenusBind {} {
    global Fpu

    for { set i 0 } { $i < 3 } { incr i } {
	bind [.disks.disk($i) childsite].picture <Button-3> [list tk_popup $Fpu($i) %X %Y]
	bind [.disks.disk($i) childsite].buttons.eject <Button-3> [list tk_popup $Fpu($i) %X %Y]
	bind [.disks.disk($i) childsite].buttons.load <Button-3> [list tk_popup $Fpu($i) %X %Y]
	bind [.disks.disk($i) childsite].enabled <Button-3> [list tk_popup $Fpu($i) %X %Y]
	bind [.disks.disk($i) childsite].wp <Button-3> [list tk_popup $Fpu($i) %X %Y]
	bind [.disks.disk($i) childsite].gauge <Button-3> [list tk_popup $Fpu($i) %X %Y]
    }
}

########################################################################
# floppySwap() -	Swaps the two floppies with each other.
########################################################################
proc floppySwap {from to} {
    global floppyLoaded
    global floppyType
    global floppyFiles
    global floppyImage
    global floppyUploadFile
    global floppyEnabled
    global floppyProtected
    global floppyFilesOS
    global floppyMemoryUsed

    set floppyLoadedTMP $floppyLoaded($to)
    set floppyTypeTMP $floppyType($to)
    set floppyFilesTMP $floppyFiles($to)
    set floppyImageTMP $floppyImage($to)
    set floppyUploadFileTMP $floppyUploadFile($to)
    set floppyEnabledTMP $floppyEnabled($to)
    set floppyProtectedTMP $floppyProtected($to)
    set floppyFilesOSTMP $floppyFilesOS($to)
    set floppyMemoryUsedTMP $floppyMemoryUsed($to)

    set floppyLoaded($to) $floppyLoaded($from)
    set floppyType($to) $floppyType($from)
    set floppyFiles($to) $floppyFiles($from)
    set floppyImage($to) $floppyImage($from)
    set floppyUploadFile($to) $floppyUploadFile($from)
    set floppyEnabled($to) $floppyEnabled($from)
    set floppyProtected($to) $floppyProtected($from)
    set floppyFilesOS($to) $floppyFilesOS($from)
    set floppyMemoryUsed($to) $floppyMemoryUsed($from)

    set floppyLoaded($from) $floppyLoadedTMP
    set floppyType($from) $floppyTypeTMP
    set floppyFiles($from) $floppyFilesTMP
    set floppyImage($from) $floppyImageTMP
    set floppyUploadFile($from) $floppyUploadFileTMP
    set floppyEnabled($from) $floppyEnabledTMP
    set floppyProtected($from) $floppyProtectedTMP
    set floppyFilesOS($from) $floppyFilesOSTMP
    set floppyMemoryUsed($from) $floppyMemoryUsedTMP

    if {$floppyLoaded($from)} {
	floppyGuiEnable $from
    } else {
	floppyGuiDisable $from
    }

    if {$floppyLoaded($to)} {
	floppyGuiEnable $to
    } else {
	floppyGuiDisable $to
    }

    floppyMemoryIndicator $from
    floppyMemoryIndicator $to
}
